#include "msp430.h"
#include "hal_usb.h"
#include "dispatcher.h"

#if 0
/*
*******************************************************************************
**  Global define
*******************************************************************************
*/
__no_init uint8_t g_ucRxBuffer[UART_IF_BUFFER_SIZE];
volatile uint16_t g_usRxBufferCounter = 0;
volatile uint8_t uart_have_cmd = 0;
#endif

/**
  * @brief  Configure the UART and specifies the baudrate
  * @caller main
  * @param None
  * @retval None
  */
void DispatcherUARTConfigure(void)
{    
 	/* Initialize UART */
	halUsbInit();
	
}

/*
**-----------------------------------------------------------------------------
**
**  Abstract:
**	This function is sends data out of the serial port.
**
**  Parameters:
**	inBuff   : A pointer to data to be sent on the UART
**  usLenght : The lenght of the data
**  Returns:
**	None
**
**-----------------------------------------------------------------------------
*/
void DispatcherUartSendPacket( uint8_t *inBuff, uint16_t usLength)
{
	halUsbSendString((char *)inBuff, usLength);	
}

#if 0
#pragma vector=USCI_A1_VECTOR
__interrupt void UART_ISR(void)
{
	uint16_t Index = g_usRxBufferCounter; 
	if(UCA1IFG & UCRXIFG)
	{
    	g_ucRxBuffer[Index] = UCA1RXBUF;
		if( ++g_usRxBufferCounter >= UART_IF_BUFFER_SIZE )
		{
			g_usRxBufferCounter = 0;
		}
		/* Indicate to main we have received a char */
		uart_have_cmd = g_ucRxBuffer[1];
	}
}
#endif
